//   File:  LED_linear_levels.pde
//
//   Use PWM to control the brightness of an LED.
//   Pattern is a linear ramp up to a constant, followed by a linear decrease
//   back to the starting intensity.  Repeat indefinitely.  Timing for each
//   phase is obtained with a separate loop.  Timing is imprecise because the
//   use of loop delays ignores time spent executing commands other than delay()
//
//   Gerald Recktenwald,  gerry@me.pdx.edu,  20 August 2011
 
int  LED_pin = 11;               //  must be one of 3, 5, 6, 9, 10 or 11

void setup() {                
  pinMode(LED_pin, OUTPUT);      // Initialize pin for output
}

void loop() {

  int  i, nin,  npause, nex, dtwait;   //  Index, repetitions for each loop, and loop delay
  int  v, Vmin=20, Vmax=220;           //  PWM output (v) and min and max values of ramps
  double  ain, bin, aex, bex;          //  Slopes and intercepts of linear output functions
  double dt, dtin, dtpause, dtex, t;   //  Timing parameters

  dt = 0.01;                      //  Time step (seconds) don't make this smaller than 10 msec
  dtwait = dt*1000;               //  Loop delay (milliseconds) corresponding to dt
  dtin = 2.0;                     //  Time interval for inhale (seconds)
  dtpause = 0.5;                  //  Time interval for pause after inhale (seconds)
  dtex = 2.5;                     //  Time intervalfor exhale (seconds)
  nin = int( dtin/dt );           //  Number of time steps during inhale
  npause = int( dtpause/dt );     //  Number of time steps during pause
  nex = int( dtex/dt );           //  Number of time steps during exhale
  
  // -- Use other time interval and range parameters to compute slopes and intercepts of v(t)
  ain = double(Vmax - Vmin)/dtin;             //  Slope during inhale
  bin = double(Vmin);                         //  Intercept during inhale
  aex = double(Vmin - Vmax)/dtex;             //  Slope during exhale
  bex = double(Vmax) - aex*(dtin + dtpause);  //  Intercept during exhale
  
  t = 0.0;
  for ( i=1; i<=nin; i++ ) {                  //   Inhale
    t += dt;
    v = int( ain*t + bin );
    analogWrite(LED_pin, v);
    delay(dtwait);
  }

  for ( i=1; i<=npause; i++ ) {               //   Pause
    t += dt;
    analogWrite(LED_pin, Vmax);
    delay(dtwait);
  }
  
  for ( i=1; i<=nex; i++ ) {                 //   Exhale
    t += dt;
    v = int( aex*t + bex );
    analogWrite(LED_pin, v);
    delay(dtwait);
  }
}
